﻿Public Class Form1

    ' TCVR Icom používá protokol tvaru FE FE A4 E0 Cn Sc Data FD
    ' Cn je příkaz (Command) Sc Subcommand
    ' Data pro nastavování/čtení frekvencí jsou složena z 5 bajtů, níže pořadí 5-4-3-2-1, data se použijí pro Cn: 00, 03, 05 a 1C 03

    Dim b0, b1, b2, b3, b4, b5, b6, b7, b8, b9 As Byte       ' deklarace bajtů - hodnoty 0 až 9
    Dim bajts(0 To 11) As Byte
    Dim vfo_a(0 To 11) As Byte
    Dim vfo_b(0 To 11) As Byte
    Dim povel_2b(0 To 11) As Byte

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load

        'přiřazení konstant protokolu Icom

        bajts(1) = 254
        vfo_a(1) = 254
        vfo_b(1) = 254
        povel_2b(1) = 254                      ' preambule FE
        bajts(2) = 254
        vfo_a(2) = 254
        vfo_b(2) = 254
        povel_2b(2) = 254                      ' preambule FE
        bajts(3) = NumericUpDown11.Value
        vfo_a(3) = NumericUpDown11.Value
        vfo_b(3) = NumericUpDown11.Value
        povel_2b(3) = NumericUpDown11.Value    ' adresa Icom 706, hexadecimálně 58
        bajts(4) = 224
        vfo_a(4) = 224
        vfo_b(4) = 224
        povel_2b(4) = 224                      ' adresa kontroleru, hex E0
        bajts(5) = 5                                                            ' příkaz set freq, příkaz hexadecimálně 00 nebo 05
        vfo_a(5) = 7
        vfo_a(6) = 0
        vfo_b(5) = 7
        vfo_b(6) = 1
        povel_2b(5) = 15
        povel_2b(6) = 1
        bajts(11) = 253
        vfo_a(7) = 253
        vfo_b(7) = 253
        povel_2b(7) = 253                     ' konec - znak FD
        povel_2b(8) = 253

    End Sub

    Private Sub Vyssi_rad()         'pro bajty b2, b4, b6 a b8 se přepočítává základ, pomocná proměnná je b0

        b0 = b2
        Zaklad()
        b2 = b0

        b0 = b4
        Zaklad()
        b4 = b0

        b0 = b6
        Zaklad()
        b6 = b0

        b0 = b8
        Zaklad()
        b8 = b0

    End Sub
    Private Sub Zaklad()            'pomocná proměnná je b0, přepočtení řádu (základu)

        If b0 = 0 Then
            b0 = 0
        End If
        If b0 = 1 Then
            b0 = 16
        End If
        If b0 = 2 Then
            b0 = 32
        End If
        If b0 = 3 Then
            b0 = 48
        End If
        If b0 = 4 Then
            b0 = 64
        End If
        If b0 = 5 Then
            b0 = 80
        End If
        If b0 = 6 Then
            b0 = 96
        End If
        If b0 = 7 Then
            b0 = 112
        End If
        If b0 = 8 Then
            b0 = 128
        End If
        If b0 = 9 Then
            b0 = 144
        End If

    End Sub
    Private Sub Nastav_com()    'nastavování sériových portů
        SerialPort1.Close()     'na otevřeném portu nelze měnit parametry
        SerialPort1.PortName = TextBox3.Text

        Dim br1 As Integer
        br1 = TextBox4.Text
        SerialPort1.BaudRate = br1
    End Sub

    Private Sub Posli_bajty()   'posílání bajtů
        SerialPort1.Close()     'když se dvakrát za sebou otevře, tak se to zesere, tak ho zavírám
        SerialPort1.Open()      'otevření serial portu
        SerialPort1.Write(bajts, 1, 11) ' toto skutečně pošle bajty do Icom 7200
    End Sub
    Private Sub Nastavuj()

        bajts(3) = NumericUpDown11.Value        'nastavení adresy TCVRu

        'přiřazení hodnot bajtům z NumericUpdown objektů pro zadávání

        b1 = NumericUpDown1.Value
        b2 = NumericUpDown2.Value
        b3 = NumericUpDown3.Value
        b4 = NumericUpDown4.Value
        b5 = NumericUpDown5.Value
        b6 = NumericUpDown6.Value
        b7 = NumericUpDown7.Value
        b8 = NumericUpDown8.Value
        b9 = 0

        Vyssi_rad()  ' procedura kvůli Icomu

        'přiřazení dvojice dvou bajtů, které tvoří jeden bajt dat v protokolu Icom

        bajts(6) = b8 + b9
        bajts(7) = b6 + b7
        bajts(8) = b4 + b5
        bajts(9) = b2 + b3
        bajts(10) = b1

        TextBox1.Text = "Set F (MHz): " + Str(bajts(10)) + ", " + Str(bajts(9)) + ", " + Str(bajts(8)) + ", " + Str(bajts(7)) + ", " + Str(bajts(6))

        Posli_bajty()              'posílání bajtů protokolem Icom
    End Sub
    Private Sub Povel_Read_F()
        bajts(1) = 254                          ' preambule FE
        bajts(2) = 254                          ' preambule FE
        bajts(3) = NumericUpDown11.Value        ' adresa Icom 706, hexadecimálně 58
        bajts(4) = 224                          ' adresa kontroleru, hex E0
        bajts(5) = 3                            ' příkaz read display freq
        bajts(6) = 253                          ' konec - znak FD 

        Posli_bajty()           'Pošle výše připravené bajty příkazu Icom
    End Sub
    Private Sub Sync()
        Nastav_com()                                'pošle nastavení portu
        Povel_Read_F()                              'pošle povel na čtení frekvence
        Timer1.Enabled = True                       'spustí pomalý timer periodického čtení
    End Sub
    Private Sub Cti_serial()
        For i As Integer = 1 To 11
            If SerialPort1.BytesToRead > 0 Then
                bajts(i) = SerialPort1.ReadByte()       ' toto přijme byte a dosadí jako číslo!
            End If
        Next i

        TextBox1.Text = "SYNC Dusimplex TX: " + Str(bajts(10)) + ", " + Str(bajts(9)) + ", " + Str(bajts(8)) + ", " + Str(bajts(7)) + ", " + Str(bajts(6))
    End Sub
    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer1.Tick
        For j = 1 To 2          'Icom nejdřív zopakuje příkaz a s druhým krokrem odešle výsledek
            Cti_serial()
        Next j

        'přiřazení konstant protokolu Icom

        bajts(1) = 254                          ' preambule FE
        bajts(2) = 254                          ' preambule FE
        bajts(3) = NumericUpDown11.Value        ' adresa Icom 706, hexadecimálně 58
        bajts(4) = 224                          ' adresa kontroleru, hex E0
        bajts(5) = 5                            ' příkaz set freq, příkaz hexadecimálně 00 nebo 05

        bajts(9) = 80                           ' bajty pro kmitočet 50 MHz
        bajts(10) = 0
        bajts(11) = 253                         ' konec - znak FD

        SerialPort1.Write(vfo_b, 1, 11)          ' nastavi VFO B

        SerialPort1.Close()
        SerialPort1.Open()

        SerialPort1.Write(bajts, 1, 11)          ' toto pošle frekvenci do Icomu

        SerialPort1.Close()
        SerialPort1.Open()

        SerialPort1.Write(vfo_a, 1, 11)          ' nastavi VFO A

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom

        Timer1.Enabled = False
        SerialPort1.Close()                     'zavře serial, kvůli přístupu druhých aplikací
    End Sub
    Private Sub Split_ON()
        povel_2b(5) = 15
        povel_2b(6) = 1

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom

        SerialPort1.Close()
    End Sub
    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Nastav_com()
        Button1.BackColor = Color.LightGray

    End Sub
    Private Sub Button2_Click_1(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Nastavuj()
    End Sub
    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        Sync()

    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs)

        SerialPort1.Close()
        SerialPort1.Open()

        TextBox1.Text = "vfo A: " + Str(vfo_a(2)) + ", " + Str(vfo_a(3)) + ", " + Str(vfo_a(4)) + ", " + Str(vfo_a(5)) + ", " + Str(vfo_a(6))
        SerialPort1.Write(vfo_a, 1, 7)          ' nastavi VFO A
        SerialPort1.Close()


    End Sub

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs)

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(vfo_b, 1, 7)          ' nastavi VFO B
        SerialPort1.Close()

    End Sub

    Private Sub Button6_Click(sender As System.Object, e As System.EventArgs)
        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 7)       ' toto pošle bajty do Icom
        SerialPort1.Close()
    End Sub

    Private Sub Button6_Click_1(sender As System.Object, e As System.EventArgs) Handles Button6.Click

        SerialPort1.Close()
        SerialPort1.Open()

        TextBox1.Text = "VFO A: " + Str(vfo_a(2)) + ", " + Str(vfo_a(3)) + ", " + Str(vfo_a(4)) + ", " + Str(vfo_a(5)) + ", " + Str(vfo_a(6))
        SerialPort1.Write(vfo_a, 1, 7)          ' nastavi VFO A
        SerialPort1.Close()

    End Sub

    Private Sub Button7_Click(sender As System.Object, e As System.EventArgs) Handles Button7.Click

        SerialPort1.Close()
        SerialPort1.Open()

        TextBox1.Text = "VFO B: " + Str(vfo_b(2)) + ", " + Str(vfo_b(3)) + ", " + Str(vfo_b(4)) + ", " + Str(vfo_b(5)) + ", " + Str(vfo_b(6))
        SerialPort1.Write(vfo_b, 1, 7)          ' nastavi VFO A
        SerialPort1.Close()

    End Sub

    Private Sub Button8_Click(sender As System.Object, e As System.EventArgs) Handles Button8.Click
        povel_2b(5) = 15
        povel_2b(6) = 1

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom 
        TextBox1.Text = "SPLIT ON: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6))
        SerialPort1.Close()
    End Sub

    Private Sub Button10_Click(sender As System.Object, e As System.EventArgs) Handles Button10.Click
        vfo_a(5) = 7
        vfo_a(6) = 160
        SerialPort1.Close()
        SerialPort1.Open()

        TextBox1.Text = "A=B: " + Str(vfo_a(2)) + ", " + Str(vfo_a(3)) + ", " + Str(vfo_a(4)) + ", " + Str(vfo_a(5)) + ", " + Str(vfo_a(6))
        SerialPort1.Write(vfo_a, 1, 7)          ' nastavi VFO A
        SerialPort1.Close()

    End Sub

    Private Sub Button9_Click(sender As System.Object, e As System.EventArgs) Handles Button9.Click
        povel_2b(5) = 15
        povel_2b(6) = 0

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "SPLIT OFF: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6))
        SerialPort1.Close()
    End Sub

    Private Sub Button3_Click_1(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        povel_2b(5) = 6
        povel_2b(6) = 1

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "USB: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6))
        SerialPort1.Close()
    End Sub

    Private Sub Button5_Click_1(sender As System.Object, e As System.EventArgs) Handles Button5.Click
        povel_2b(5) = 6
        povel_2b(6) = 0

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "LSB: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6))
        SerialPort1.Close()
    End Sub

    Private Sub Button16_Click(sender As System.Object, e As System.EventArgs) Handles Button16.Click
        povel_2b(5) = 17
        povel_2b(6) = 32

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "ATT ON: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6))
        SerialPort1.Close()
    End Sub

    Private Sub Button15_Click(sender As System.Object, e As System.EventArgs) Handles Button15.Click
        povel_2b(5) = 17
        povel_2b(6) = 0

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "ATT OFF: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6))
        SerialPort1.Close()
    End Sub

    Private Sub Button11_Click(sender As System.Object, e As System.EventArgs) Handles Button11.Click
        povel_2b(5) = 22
        povel_2b(6) = 2
        povel_2b(7) = 1
        povel_2b(8) = 253

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "PRE ON: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6)) + ", " + Str(povel_2b(7))
        SerialPort1.Close()
        povel_2b(7) = 253
    End Sub

    Private Sub Button12_Click(sender As System.Object, e As System.EventArgs) Handles Button12.Click
        povel_2b(5) = 22
        povel_2b(6) = 2
        povel_2b(7) = 0
        povel_2b(8) = 253

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "PRE OFF: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6)) + ", " + Str(povel_2b(7))
        SerialPort1.Close()
        povel_2b(7) = 253
    End Sub

    Private Sub Button13_Click(sender As System.Object, e As System.EventArgs) Handles Button13.Click
        povel_2b(5) = 22
        povel_2b(6) = 68
        povel_2b(7) = 1
        povel_2b(8) = 253

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "Compressor ON: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6)) + ", " + Str(povel_2b(7))
        SerialPort1.Close()
        povel_2b(7) = 253
    End Sub

    Private Sub Button14_Click(sender As System.Object, e As System.EventArgs) Handles Button14.Click
        povel_2b(5) = 22
        povel_2b(6) = 68
        povel_2b(7) = 0
        povel_2b(8) = 253

        SerialPort1.Close()
        SerialPort1.Open()
        SerialPort1.Write(povel_2b, 1, 11)       ' toto pošle bajty do Icom
        TextBox1.Text = "Compressor OFF: " + Str(povel_2b(2)) + ", " + Str(povel_2b(3)) + ", " + Str(povel_2b(4)) + ", " + Str(povel_2b(5)) + ", " + Str(povel_2b(6)) + ", " + Str(povel_2b(7))
        SerialPort1.Close()
        povel_2b(7) = 253
    End Sub
End Class
